package com.yd.email.api.service.impl;

import com.yd.common.result.Result;
import com.yd.email.api.service.ApiEmailTaskRecipientsService;
import com.yd.email.service.dto.EmailContactImportDto;
import com.yd.email.service.model.EmailContactImport;
import com.yd.email.service.model.EmailTaskRecipients;
import com.yd.email.service.service.IEmailContactImportService;
import com.yd.email.service.service.IEmailTaskRecipientsService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 邮件任务收件人实现类
 */
@Service
@Slf4j
public class ApiEmailTaskRecipientsServiceImpl implements ApiEmailTaskRecipientsService {

    @Autowired
    private IEmailContactImportService iEmailContactImportService;

    @Autowired
    private IEmailTaskRecipientsService iEmailTaskRecipientsService;

    /**
     * 根据当前当前会话id和数据来源查询导入数据，保存到邮件任务收件人关联表中
     * @param taskBizId 邮件任务唯一业务ID
     * @param status 收件人邮件状态
     * @param sessionId 会话id
     * @param source 数据的来源 0-选择联系人导入 1-excel导入联系人
     * @return
     */
    public Result<List<EmailTaskRecipients>> saveEmailTaskRecipientsBySessionId(String taskBizId,String status,
                                                     String sessionId,Integer source) {
        //根据当前当前会话id和数据来源查询的导入数据
        List<EmailContactImport> emailContactImportList = iEmailContactImportService.queryList(EmailContactImportDto
                .builder()
                .sessionId(sessionId)
                .source(source)
                .build());
        if (!CollectionUtils.isEmpty(emailContactImportList)) {
            //不为空，保存到邮件任务收件人关联表中
            List<EmailTaskRecipients> saveRecipientsList = emailContactImportList
                    .stream()
                    .map(dto -> {
                        EmailTaskRecipients recipient = new EmailTaskRecipients();
                        BeanUtils.copyProperties(dto,recipient);
                        recipient.setTaskBizId(taskBizId);
                        recipient.setStatus(status);
                        return recipient;
                    }).collect(Collectors.toList());
            //保存到邮件任务收件人关联表中
            iEmailTaskRecipientsService.saveOrUpdateBatch(saveRecipientsList);
        }

        return Result.success();
    }
}
