package com.yd.email.feign.fallback;

import com.yd.common.result.Result;
import com.yd.email.feign.client.ApiEmailVariableGroupFeignClient;
import com.yd.email.feign.request.ApiEmailVariableGroupAddRequest;
import com.yd.email.feign.request.ApiEmailVariableGroupEditRequest;
import com.yd.email.feign.request.ApiEmailVariableGroupPageRequest;
import com.yd.email.feign.response.ApiEmailVariableGroupDetailResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 邮箱服务-变量分组信息Feign降级处理
 */
@Slf4j
@Component
public class ApiEmailVariableGroupFeignFallbackFactory implements FallbackFactory<ApiEmailVariableGroupFeignClient> {
    @Override
    public ApiEmailVariableGroupFeignClient create(Throwable cause) {
        return new ApiEmailVariableGroupFeignClient() {
            @Override
            public Result page(ApiEmailVariableGroupPageRequest request) {
                return null;
            }

            @Override
            public Result add(ApiEmailVariableGroupAddRequest request) {
                return null;
            }

            @Override
            public Result edit(ApiEmailVariableGroupEditRequest request) {
                return null;
            }

            @Override
            public Result<ApiEmailVariableGroupDetailResponse> detail(String variableGroupBizId) {
                return null;
            }

            @Override
            public Result del(String variableGroupBizId) {
                return null;
            }
        };
    }
}
