package com.yd.email.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.yd.email.service.dto.EmailContactCcDto;
import com.yd.email.service.model.EmailContact;
import com.yd.email.service.model.EmailContactCc;
import com.yd.email.service.dao.EmailContactCcMapper;
import com.yd.email.service.service.IEmailContactCcService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 收件人和抄送密送信息关联表（冗余表，可带入到邮件任务的抄送密送数据） 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-09-22
 */
@Service
public class EmailContactCcServiceImpl extends ServiceImpl<EmailContactCcMapper, EmailContactCc> implements IEmailContactCcService {

    /**
     * 根据联系人业务id删除关系
     * @param contactBizId
     * @return
     */
    @Override
    public Boolean delByContactBizId(String contactBizId) {
        return this.remove(new LambdaQueryWrapper<EmailContactCc>().eq(EmailContactCc::getContactBizId,contactBizId));
    }

    /**
     * 查询列表
     * @param dto
     * @return
     */
    @Override
    public List<EmailContactCc> queryList(EmailContactCcDto dto) {
        List<EmailContactCc> list = baseMapper.selectList(new LambdaQueryWrapper<EmailContactCc>()
                .eq(StringUtils.isNotBlank(dto.getContactBizId()),EmailContactCc::getContactBizId,dto.getContactBizId())
                .eq(StringUtils.isNotBlank(dto.getType()),EmailContactCc::getType,dto.getType())
        );
        return list;
    }
}
