package com.yd.email.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.email.feign.request.ApiEmailVariablePageRequest;
import com.yd.email.feign.response.ApiEmailVariablePageResponse;
import com.yd.email.service.dto.EmailVariableDto;
import com.yd.email.service.model.EmailProviderConfig;
import com.yd.email.service.model.EmailVariable;
import com.yd.email.service.dao.EmailVariableMapper;
import com.yd.email.service.service.IEmailVariableService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * <p>
 * 变量表（邮件内容占位符） 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-09-19
 */
@Service
public class EmailVariableServiceImpl extends ServiceImpl<EmailVariableMapper, EmailVariable> implements IEmailVariableService {

    @Override
    public IPage<ApiEmailVariablePageResponse> page(Page<ApiEmailVariablePageResponse> page,
                                                    ApiEmailVariablePageRequest request) {
        return baseMapper.page(page,request);
    }

    /**
     * 查询列表
     * @param dto
     * @return
     */
    @Override
    public List<EmailVariable> queryList(EmailVariableDto dto) {
        List<EmailVariable> list = baseMapper.selectList(new LambdaQueryWrapper<EmailVariable>()
                .eq(StringUtils.isNotBlank(dto.getVariableBizId()) && !dto.getIsExcludeMy(),EmailVariable::getVariableBizId,dto.getVariableBizId())
                .eq(StringUtils.isNotBlank(dto.getVariableNameCn()),EmailVariable::getVariableNameCn,dto.getVariableNameCn())
                .eq(StringUtils.isNotBlank(dto.getVariableNameEn()),EmailVariable::getVariableNameEn,dto.getVariableNameEn())
                .in(!CollectionUtils.isEmpty(dto.getVariableBizIdList()),EmailVariable::getVariableBizId,dto.getVariableBizIdList())
                .in(!CollectionUtils.isEmpty(dto.getVariableNameCnList()),EmailVariable::getVariableNameCn,dto.getVariableNameCnList())
                .ne(dto.getIsExcludeMy(),EmailVariable::getVariableBizId,dto.getVariableBizId())
        );
        return list;
    }

    /**
     * 查询单个对象
     * @param variableBizId
     * @return
     */
    @Override
    public EmailVariable queryOne(String variableBizId) {
        return this.getOne(new LambdaQueryWrapper<EmailVariable>().eq(EmailVariable::getVariableBizId,variableBizId));
    }
}
