package com.yd.email.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.email.feign.request.ApiEmailTaskPageRequest;
import com.yd.email.feign.response.ApiEmailTaskPageResponse;
import com.yd.email.service.model.EmailTask;
import com.yd.email.service.dao.EmailTaskMapper;
import com.yd.email.service.service.IEmailTaskService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 邮件任务表（存储邮件发送任务信息） 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-09-19
 */
@Service
public class EmailTaskServiceImpl extends ServiceImpl<EmailTaskMapper, EmailTask> implements IEmailTaskService {

    @Override
    public IPage<ApiEmailTaskPageResponse> page(Page<ApiEmailTaskPageResponse> page,
                                                ApiEmailTaskPageRequest request) {
        return baseMapper.page(page,request);
    }

    /**
     * 查询单个对象
     * @param taskBizId
     * @return
     */
    @Override
    public EmailTask queryOne(String taskBizId) {
        return this.getOne(new LambdaQueryWrapper<EmailTask>().eq(EmailTask::getTaskBizId,taskBizId));
    }

}
