package com.yd.email.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.email.feign.request.ApiEmailTaskRecipientsPageRequest;
import com.yd.email.feign.response.ApiEmailTaskRecipientsPageResponse;
import com.yd.email.service.model.EmailContactImport;
import com.yd.email.service.model.EmailTaskRecipients;
import com.yd.email.service.dao.EmailTaskRecipientsMapper;
import com.yd.email.service.service.IEmailTaskRecipientsService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 邮件任务收件人关联表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-09-19
 */
@Service
public class EmailTaskRecipientsServiceImpl extends ServiceImpl<EmailTaskRecipientsMapper, EmailTaskRecipients> implements IEmailTaskRecipientsService {

    @Override
    public IPage<ApiEmailTaskRecipientsPageResponse> page(Page<ApiEmailTaskRecipientsPageResponse> page,
                                                          ApiEmailTaskRecipientsPageRequest request) {
        return baseMapper.page(page,request);
    }

    /**
     * 根据任务业务id查询邮件任务收件人关联列表
     * @param taskBizId
     * @return
     */
    @Override
    public List<EmailTaskRecipients> queryList(String taskBizId) {
        List<EmailTaskRecipients> list = baseMapper.selectList(new LambdaQueryWrapper<EmailTaskRecipients>()
                .eq(StringUtils.isNotBlank(taskBizId),EmailTaskRecipients::getTaskBizId,taskBizId)
        );
        return list;
    }

}
