package com.yd.email.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.email.feign.request.ApiEmailSenderConfigPageRequest;
import com.yd.email.feign.response.ApiEmailSenderConfigPageResponse;
import com.yd.email.service.dto.EmailSenderConfigDto;
import com.yd.email.service.model.EmailSenderConfig;
import com.yd.email.service.dao.EmailSenderConfigMapper;
import com.yd.email.service.service.IEmailSenderConfigService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yd.user.service.model.SysMenu;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;

/**
 * <p>
 * 发件人配置表（存储SMTP服务器配置信息） 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-09-19
 */
@Service
public class EmailSenderConfigServiceImpl extends ServiceImpl<EmailSenderConfigMapper, EmailSenderConfig> implements IEmailSenderConfigService {

    @Override
    public IPage<ApiEmailSenderConfigPageResponse> page(Page<ApiEmailSenderConfigPageResponse> page,
                                                        ApiEmailSenderConfigPageRequest request) {
        return baseMapper.page(page,request);
    }

    /**
     * 查询列表
     * @param dto
     * @return
     */
    @Override
    public List<EmailSenderConfig> queryList(EmailSenderConfigDto dto) {
        List<EmailSenderConfig> list = baseMapper.selectList(new LambdaQueryWrapper<EmailSenderConfig>()
                .eq(StringUtils.isNotBlank(dto.getSenderBizId()) && !dto.getIsExcludeMy(),EmailSenderConfig::getSenderBizId,dto.getSenderBizId())
                .eq(StringUtils.isNotBlank(dto.getEmail()),EmailSenderConfig::getEmail,dto.getEmail())
                .ne(dto.getIsExcludeMy(),EmailSenderConfig::getSenderBizId,dto.getSenderBizId())
        );
        return list;
    }

    /**
     * 查询单个对象
     * @param senderBizId
     * @return
     */
    @Override
    public EmailSenderConfig queryOne(String senderBizId) {
        return this.getOne(new LambdaQueryWrapper<EmailSenderConfig>().eq(EmailSenderConfig::getSenderBizId,senderBizId));
    }

}
