package com.yd.email.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 收件人和抄送密送信息关联表（冗余表，可带入到邮件任务的抄送密送数据）
 * </p>
 *
 * @author zxm
 * @since 2025-09-22
 */
@Getter
@Setter
@TableName("email_contact_cc")
public class EmailContactCc implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 收件人唯一业务ID（联系人唯一业务ID）
     */
    @TableField("contact_biz_id")
    private String contactBizId;

    /**
     * 类型：TCC-抄送, BCC-密送
     */
    @TableField("type")
    private String type;

    /**
     * 姓名（抄送或者密送）
     */
    @TableField("name")
    private String name;

    /**
     * 邮箱（抄送或者密送）
     */
    @TableField("email")
    private String email;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
