package com.yd.email.service.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class EmailContactDto {

    /**
     * 收件人唯一业务ID（联系人唯一业务ID）
     */
    private String contactBizId;

    /**
     * 联系人邮箱
     */
    private String email;

    /**
     * 联系人邮箱集合
     */
    private List<String> emailList;

    /**
     * 查询是否排除当前发件人唯一标识数据，默认false不排除，true的话senderBizId必传
     */
    @Builder.Default
    private Boolean isExcludeMy = false;
}
