package com.yd.email.feign.response;

import lombok.Data;

import java.time.LocalDateTime;

@Data
public class ApiEmailTaskRecipientsPageResponse {

    /**
     * 邮件任务收件人关联表主键ID
     */
    private Long id;

    /**
     * 邮件任务唯一业务ID
     */
    private String taskBizId;

    /**
     * 收件人唯一业务ID（联系人唯一业务ID）
     */
    private String contactBizId;

    /**
     * 收件人邮箱
     */
    private String receiveEmail;

    /**
     * 抄送人邮箱（多个用分号分隔）
     */
    private String ccEmail;

    /**
     * 收件人邮件状态：PENDING-待发送, SENDING-发送中, COMPLETED-已完成, FAILED-发送失败, CANCELLED-已取消
     */
    private String status;

    /**
     * 实际发送时间
     */
    private LocalDateTime sendTime;

    /**
     * 发送失败的错误信息
     */
    private String errorMsg;
}
