package com.yd.email.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yd.email.service.model.EmailVariable;
import com.yd.email.service.model.RelVariableGroup;
import com.yd.email.service.dao.RelVariableGroupMapper;
import com.yd.email.service.service.IRelVariableGroupService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 变量分组关系表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-09-22
 */
@Service
public class RelVariableGroupServiceImpl extends ServiceImpl<RelVariableGroupMapper, RelVariableGroup> implements IRelVariableGroupService {

    /**
     * 根据分组业务id删除关系
     * @param variableGroupBizId
     * @return
     */
    @Override
    public Boolean delRelByVariableGroupBizId(String variableGroupBizId) {
        return this.remove(new LambdaQueryWrapper<RelVariableGroup>().eq(RelVariableGroup::getVariableGroupBizId,variableGroupBizId));
    }

    /**
     * 查询列表
     * @param variableGroupBizId
     * @return
     */
    @Override
    public List<RelVariableGroup> queryList(String variableGroupBizId) {
        List<RelVariableGroup> list = baseMapper.selectList(new LambdaQueryWrapper<RelVariableGroup>()
                .eq(StringUtils.isNotBlank(variableGroupBizId),RelVariableGroup::getVariableGroupBizId,variableGroupBizId)
        );
        return list;
    }
}
