package com.yd.email.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.email.feign.request.ApiEmailContactImportPageRequest;
import com.yd.email.feign.response.ApiEmailContactImportPageResponse;
import com.yd.email.service.dto.EmailContactImportDto;
import com.yd.email.service.model.EmailContact;
import com.yd.email.service.model.EmailContactImport;
import com.yd.email.service.dao.EmailContactImportMapper;
import com.yd.email.service.service.IEmailContactImportService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

/**
 * <p>
 * 邮件联系人导入临时表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-09-23
 */
@Service
public class EmailContactImportServiceImpl extends ServiceImpl<EmailContactImportMapper, EmailContactImport> implements IEmailContactImportService {

    @Override
    public IPage<ApiEmailContactImportPageResponse> page(Page<ApiEmailContactImportPageResponse> page,
                                                         ApiEmailContactImportPageRequest request) {
        return baseMapper.page(page,request);
    }

    /**
     * 查询单个对象
     * @param importBizId
     * @return
     */
    @Override
    public EmailContactImport queryOne(String importBizId) {
        return this.getOne(new LambdaQueryWrapper<EmailContactImport>().eq(EmailContactImport::getImportBizId,importBizId));
    }

    /**
     * 查询列表
     * @param dto
     * @return
     */
    @Override
    public List<EmailContactImport> queryList(EmailContactImportDto dto) {
        List<EmailContactImport> list = baseMapper.selectList(new LambdaQueryWrapper<EmailContactImport>()
                .eq(StringUtils.isNotBlank(dto.getImportBizId()) && !dto.getIsExcludeMy(),EmailContactImport::getImportBizId,dto.getImportBizId())
                .eq(StringUtils.isNotBlank(dto.getSessionId()),EmailContactImport::getSessionId,dto.getSessionId())
                .eq(StringUtils.isNotBlank(dto.getReceiveEmail()),EmailContactImport::getReceiveEmail,dto.getReceiveEmail())
                .eq(!Objects.isNull(dto.getSource()),EmailContactImport::getSource,dto.getSource())
                .ne(dto.getIsExcludeMy(),EmailContactImport::getImportBizId,dto.getImportBizId())
        );
        return list;
    }
}
