package com.yd.email.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 邮件模板表（存储邮件内容）
 * </p>
 *
 * @author zxm
 * @since 2025-09-19
 */
@Getter
@Setter
@TableName("email_template")
public class EmailTemplate implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 邮件模板唯一业务ID
     */
    @TableField("template_biz_id")
    private String templateBizId;

    /**
     * 模板名称
     */
    @TableField("name")
    private String name;

    /**
     * 邮件主题
     */
    @TableField("subject")
    private String subject;

    /**
     * 邮件内容
     */
    @TableField("content")
    private String content;

    /**
     * 邮件内容是否为HTML格式: 0-否, 1-是（字典）
     */
    @TableField("is_html")
    private Integer isHtml;

    /**
     * 邮件内容是否包含占位符: 0-否, 1-是（字典）
     */
    @TableField("is_placeholder")
    private Integer isPlaceholder;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
