package com.yd.email.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 邮件文件表
 * </p>
 *
 * @author zxm
 * @since 2025-09-25
 */
@Getter
@Setter
@TableName("email_file")
public class EmailFile implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 邮件附件表唯一业务ID
     */
    @TableField("email_file_biz_id")
    private String emailFileBizId;

    /**
     * OSS文件业务ID唯一标识（中台文件元数据表）
     */
    @TableField("oss_file_biz_id")
    private String ossFileBizId;

    /**
     * 操作类型: 0-上传, 1-导出，2-导入
     */
    @TableField("opr_type")
    private Integer oprType;

    /**
     * 操作对象: 0-变量管理, 1-联系人管理，2-发送邮件 3-联系人导入临时表
     */
    @TableField("opr_object")
    private Integer oprObject;

    /**
     * 操作对象ID，例：操作对象是发送邮件那么就是发送邮件任务表业务id，联系人导入临时表是会话id（没有值就空着）
     */
    @TableField("opr_object_id")
    private String oprObjectId;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
