package com.yd.email.feign.response;

import lombok.Data;
import java.time.LocalDateTime;

@Data
public class ApiEmailContactImportPageResponse {

    /**
     * 邮件联系人导入临时表主键ID
     */
    private Long id;

    /**
     * 导入临时表唯一业务ID
     */
    private String importBizId;

    /**
     * 当前会话id（前端使用，用于查询。存于前端缓存）
     */
    private String sessionId;

    /**
     * 收件人唯一业务ID（联系人唯一业务ID，导入excel无值，选择联系人有值）
     */
    private String contactBizId;

    /**
     * 收件人邮箱（单个）
     */
    private String receiveEmail;

    /**
     * 抄送人邮箱（多个用分号分隔）
     */
    private String ccEmail;

    /**
     * 密送人邮箱（多个用分号分隔）
     */
    private String bccEmail;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;
}
