package com.yd.email.feign.fallback;

import com.yd.common.result.Result;
import com.yd.email.feign.client.ApiEmailVariableFeignClient;
import com.yd.email.feign.request.ApiEmailVariableAddRequest;
import com.yd.email.feign.request.ApiEmailVariableEditRequest;
import com.yd.email.feign.request.ApiEmailVariablePageRequest;
import com.yd.email.feign.response.ApiEmailVariableDetailResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 邮箱服务-变量信息（邮件内容占位符）Feign降级处理
 */
@Slf4j
@Component
public class ApiEmailVariableFeignFallbackFactory implements FallbackFactory<ApiEmailVariableFeignClient> {

    @Override
    public ApiEmailVariableFeignClient create(Throwable cause) {
        return new ApiEmailVariableFeignClient() {
            @Override
            public Result page(ApiEmailVariablePageRequest request) {
                return null;
            }

            @Override
            public Result add(ApiEmailVariableAddRequest request) {
                return null;
            }

            @Override
            public Result edit(ApiEmailVariableEditRequest request) {
                return null;
            }

            @Override
            public Result<ApiEmailVariableDetailResponse> detail(String variableBizId) {
                return null;
            }

            @Override
            public Result del(String variableBizId) {
                return null;
            }
        };
    }
}
