package com.yd.email.feign.fallback;

import com.yd.common.result.Result;
import com.yd.email.feign.client.ApiEmailTaskFeignClient;
import com.yd.email.feign.request.ApiEmailTaskPageRequest;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 邮箱服务-邮件任务信息（存储邮件发送任务信息）Feign降级处理
 */
@Slf4j
@Component
public class ApiEmailTaskFeignFallbackFactory implements FallbackFactory<ApiEmailTaskFeignClient> {
    @Override
    public ApiEmailTaskFeignClient create(Throwable cause) {
        return new ApiEmailTaskFeignClient() {
            @Override
            public Result page(ApiEmailTaskPageRequest request) {
                return null;
            }
        };
    }
}
