package com.yd.email.api.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.email.feign.dto.ApiEmailSenderConfigDto;
import com.yd.email.feign.request.ApiEmailSenderConfigAddRequest;
import com.yd.email.feign.request.ApiEmailSenderConfigEditRequest;
import com.yd.email.feign.request.ApiEmailSenderConfigPageRequest;
import com.yd.email.feign.request.ApiEmailSenderValidateRequest;
import com.yd.email.feign.response.ApiEmailSenderConfigDetailResponse;
import com.yd.email.feign.response.ApiEmailSenderConfigPageResponse;

public interface ApiEmailSenderConfigService {

    Result<IPage<ApiEmailSenderConfigPageResponse>> page(ApiEmailSenderConfigPageRequest request);

    Result add(ApiEmailSenderConfigAddRequest request);

    Result edit(ApiEmailSenderConfigEditRequest request);

    Result<ApiEmailSenderConfigDetailResponse> detail(String senderBizId);

    Result del(String senderBizId);

    Result<ApiEmailSenderConfigDto> getApiEmailSenderConfigDto(String senderBizId);

    Result validateEmailConfig(ApiEmailSenderValidateRequest request);
}
