package com.yd.email.api.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.email.feign.request.ApiEmailProviderConfigAddRequest;
import com.yd.email.feign.request.ApiEmailProviderConfigEditRequest;
import com.yd.email.feign.request.ApiEmailProviderConfigPageRequest;
import com.yd.email.feign.response.ApiEmailProviderConfigDetailResponse;
import com.yd.email.feign.response.ApiEmailProviderConfigPageResponse;
import com.yd.email.service.model.EmailProviderConfig;

public interface ApiEmailProviderConfigService {


    Result<IPage<ApiEmailProviderConfigPageResponse>> page(ApiEmailProviderConfigPageRequest request);

    Result add(ApiEmailProviderConfigAddRequest request);

    Result edit(ApiEmailProviderConfigEditRequest request);

    Result<ApiEmailProviderConfigDetailResponse> detail(String providerBizId);

    Result del(String providerBizId);

    Result<EmailProviderConfig> checkEmailProviderConfigIsExist(String providerBizId);
}
