package com.yd.email.api.controller;

import com.yd.common.result.Result;
import com.yd.email.api.service.ApiEmailFileService;
import com.yd.email.feign.client.ApiEmailFileFeignClient;
import com.yd.email.feign.request.ApiExportVariableExcelRequest;
import com.yd.email.feign.request.ApiImportVariableExcelRequest;
import com.yd.email.feign.response.ApiExportVariableExcelResponse;
import com.yd.email.feign.response.ApiImportContactExcelResponse;
import com.yd.email.feign.response.ApiImportVariableExcelResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

/**
 * 邮件文件信息
 *
 * @author zxm
 * @since 2025-09-25
 */
@RestController
@RequestMapping("/emailFile")
@Validated
public class ApiEmailFileController implements ApiEmailFileFeignClient {

    @Autowired
    private ApiEmailFileService apiEmailFileService;

    /**
     * 导出-变量excel
     * @param request
     * @return
     */
    @Override
    public Result<ApiExportVariableExcelResponse> exportVariableExcel(ApiExportVariableExcelRequest request) {
        return apiEmailFileService.exportVariableExcel(request);
    }

    /**
     * 导入-变量excel
     * @param file
     * @param request
     * @return
     */
    @Override
    public Result<ApiImportVariableExcelResponse> importVariableExcel(MultipartFile file,
                                                                      ApiImportVariableExcelRequest request) {
        return apiEmailFileService.importVariableExcel(file,request);
    }

    /**
     * 导入-联系人excel
     * @param file
     * @return
     */
    @Override
    public Result importContactExcel(MultipartFile file) {
        return apiEmailFileService.importContactExcel(file);
    }
}
