package com.yd.email.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.email.api.service.ApiEmailContactImportService;
import com.yd.email.feign.client.ApiEmailContactImportFeignClient;
import com.yd.email.feign.request.ApiEmailContactImportEditRequest;
import com.yd.email.feign.request.ApiEmailContactImportPageRequest;
import com.yd.email.feign.request.ApiEmailContactImportSelectAddRequest;
import com.yd.email.feign.response.ApiEmailContactImportPageResponse;
import com.yd.email.feign.response.ApiEmailContactImportResponse;
import com.yd.email.feign.response.ApiEmailContactImportSelectAddResponse;
import com.yd.email.feign.response.ApiEmailContactImportSessionResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 邮件联系人导入临时表信息
 *
 * @author zxm
 * @since 2025-09-23
 */
@RestController
@RequestMapping("/emailContactImport")
@Validated
public class ApiEmailContactImportController implements ApiEmailContactImportFeignClient {

    @Autowired
    private ApiEmailContactImportService apiEmailContactImportService;

    /**
     * 分页查询-邮件联系人导入的列表
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiEmailContactImportPageResponse>> page(ApiEmailContactImportPageRequest request) {
        return apiEmailContactImportService.page(request);
    }

    /**
     * 添加-选择联系人（写邮件选择联系人的时候保存的接口）
     * @param request
     * @return
     */
    @Override
    public Result<ApiEmailContactImportSelectAddResponse> add(ApiEmailContactImportSelectAddRequest request) {
        return apiEmailContactImportService.add(request);
    }

    /**
     * 编辑-邮件联系人导入信息
     * @param request
     * @return
     */
    @Override
    public Result edit(ApiEmailContactImportEditRequest request) {
        return apiEmailContactImportService.edit(request);
    }

    /**
     * 详情-邮件联系人导入信息
     * @param importBizId 导入临时表唯一业务ID
     * @return
     */
    @Override
    public Result<ApiEmailContactImportResponse> detail(String importBizId) {
        return apiEmailContactImportService.detail(importBizId);
    }

    /**
     * 详情-会话
     * @param sessionId 会话id
     * @return
     */
    @Override
    public Result<ApiEmailContactImportSessionResponse> detailSessionId(String sessionId) {
        return apiEmailContactImportService.detailSessionId(sessionId);
    }

    /**
     * 删除-邮件联系人导入信息
     * @param importBizId 导入临时表唯一业务ID
     * @return
     */
    @Override
    public Result del(String importBizId) {
        return apiEmailContactImportService.del(importBizId);
    }


}
