package com.yd.email.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.common.result.Result;
import com.yd.email.api.service.ApiEmailTaskService;
import com.yd.email.feign.request.ApiEmailTaskPageRequest;
import com.yd.email.feign.response.ApiEmailTaskPageResponse;
import com.yd.email.service.service.IEmailTaskService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 邮件任务实现类
 */
@Slf4j
@Service
public class ApiEmailTaskServiceImpl implements ApiEmailTaskService {

    @Autowired
    private IEmailTaskService iEmailTaskService;

    /**
     * 分页查询-邮件任务（主线任务）
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiEmailTaskPageResponse>> page(ApiEmailTaskPageRequest request) {
        Page<ApiEmailTaskPageResponse> page = new Page<>(request.getPageNo(), request.getPageSize());
        IPage<ApiEmailTaskPageResponse> iPage = iEmailTaskService.page(page, request);
        return Result.success(iPage);
    }

}
