package com.yd.email.feign.fallback;

import com.yd.common.result.Result;
import com.yd.email.feign.client.ApiEmailContactFeignClient;
import com.yd.email.feign.request.ApiEmailContactAddRequest;
import com.yd.email.feign.request.ApiEmailContactEditRequest;
import com.yd.email.feign.request.ApiEmailContactPageRequest;
import com.yd.email.feign.response.ApiEmailContactDetailResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 邮箱服务-联系人信息（存储收件人信息）Feign降级处理
 */
@Slf4j
@Component
public class ApiEmailContactFeignFallbackFactory implements FallbackFactory<ApiEmailContactFeignClient> {
    @Override
    public ApiEmailContactFeignClient create(Throwable cause) {
        return new ApiEmailContactFeignClient() {
            @Override
            public Result page(ApiEmailContactPageRequest request) {
                return null;
            }

            @Override
            public Result add(ApiEmailContactAddRequest request) {
                return null;
            }

            @Override
            public Result edit(ApiEmailContactEditRequest request) {
                return null;
            }

            @Override
            public Result<ApiEmailContactDetailResponse> detail(String contactBizId) {
                return null;
            }

            @Override
            public Result del(String contactBizId) {
                return null;
            }
        };
    }
}
