package com.yd.csf.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 第二持有人信息表
 * </p>
 *
 * @author zxm
 * @since 2025-09-01
 */
@Getter
@Setter
@TableName("second_holder")
public class SecondHolder implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 预约信息主表唯一业务ID
     */
    @TableField("appointment_biz_id")
    private String appointmentBizId;

    /**
     * 第二持有人信息表唯一业务ID
     */
    @TableField("second_holder_biz_id")
    private String secondHolderBizId;

    /**
     * 与受保人关系（字典）
     */
    @TableField("insurant_rel")
    private String insurantRel;

    /**
     * 名字
     */
    @TableField("name")
    private String name;

    /**
     * 名字-英文
     */
    @TableField("name_en")
    private String nameEn;

    /**
     * 性别（字典）
     */
    @TableField("gender")
    private String gender;

    /**
     * 证件类型（字典）
     */
    @TableField("document_type")
    private String documentType;

    /**
     * 证件号码
     */
    @TableField("id_number")
    private String idNumber;

    /**
     * 护照号码
     */
    @TableField("passport_number")
    private String passportNumber;

    /**
     * 出生日期
     */
    @TableField("birth_time")
    private LocalDateTime birthTime;

    /**
     * 年龄
     */
    @TableField("age")
    private String age;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
