package com.yd.csf.service.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yd.common.dto.PageDto;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.util.Date;

@Data
public class FortuneAccountQueryRequest extends PageDto {

    @Schema(description = "转介人")
    private String broker;

    @Schema(description = "所属团队")
    private String team;

    @Schema(description = "出账状态 字典值：csf_fortune_account_status")
    private String status;

    @Schema(description = "出账日期开始", format = "date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date accountDateStart;

    @Schema(description = "出账日期结束", format = "date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date accountDateEnd;
}
