package com.yd.csf.service.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
public class FortuneUpdateRequest implements Serializable {
    /**
     * 保单发佣业务id
     */
    @Schema(description = "保单发佣业务id", requiredMode = Schema.RequiredMode.REQUIRED)
    private String fortuneBizId;

    /**
     * 出账检核年月 yyyy-MM
     */
    @Schema(description = "出账检核年月 yyyy-MM")
    private String reconciliationYearMonth;

    /**
     * 出账状态
     */
    @Schema(description = "出账状态 4=保留 5=已失效 6=可出帐，检核完成")
    private String status;

    /**
     * 保单号
     */
    @Schema(description = "保单号")
    private String policyNo;

    /**
     * 发佣期数(1=第一年; 2=第二年; 3=第三年; 4=第四年; 5=第五年)
     */
    @Schema(description = "发佣期数(1=第一年; 2=第二年; 3=第三年; 4=第四年; 5=第五年)")
    private Integer fortunePeriod;

    /**
     * 发佣总期数
     */
    @Schema(description = "发佣总期数")
    private Integer fortuneTotalPeriod;

    /**
     * 转介人
     */
    @Schema(description = "转介人")
    private String broker;

    /**
     * 转介人业务ID
     */
    @Schema(description = "转介人业务ID")
    private String brokerBizId;

    /**
     * 所属团队
     */
    @Schema(description = "所属团队")
    private String team;

    /**
     * 所属团队业务ID
     */
    @Schema(description = "所属团队业务ID")
    private String teamBizId;

    /**
     * 发佣名称
     */
    @Schema(description = "发佣名称")
    private String fortuneName;

    /**
     * 发佣类型
     */
    @Schema(description = "发佣类型")
    private String fortuneType;

    /**
     * 发佣金额
     */
    @Schema(description = "发佣金额")
    private BigDecimal amount;

    /**
     * 发佣币种
     */
    @Schema(description = "发佣币种")
    private String currency;

    /**
     * 发佣日期
     */
    @Schema(description = "发佣日期")
    private Date payoutDate;

    /**
     * 备注
     */
    @Schema(description = "备注")
    private String remark;

    private static final long serialVersionUID = 1L;
}
