package com.yd.csf.service.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yd.csf.service.model.Policy;
import com.yd.csf.service.model.PolicyBroker;
import com.yd.csf.service.model.PolicyFollow;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.springframework.beans.BeanUtils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 新单跟进视图
 *
 */
@Data
public class PolicyFollowVO implements Serializable {

    /**
     * 新单跟进唯一业务ID
     */
    @Schema(description = "新单跟进唯一业务ID")
    private String policyBizId;

     /**
     * 预约业务id
     */
    @Schema(description = "预约业务id")
    private String appointmentBizId;

    /**
     * 预约单号
     */
    @Schema(description = "预约单号")
    private String appointmentNo;

    /**
     * 保单号
     */
    @Schema(description = "保单号")
    private String policyNo;

    /**
     * 用户业务id
     */
    @Schema(description = "用户业务id")
    private String userBizId;

    /**
     * 客户业务id
     */
    @Schema(description = "客户业务id")
    private String customerBizId;

    /**
     * 客户名称
     */
    @Schema(description = "客户名称")
    private String customerName;

    /**
     * 签单日期
     */
    @Schema(description = "签单日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date signDate;

    /**
     * 签单人
     */
    @Schema(description = "签单人")
    private String signer;

    /**
     * 缮发日期
     */
    private Date issueDate;

    /**
     * 生效日期
     */
    private Date effectiveDate;

    /**
     * 续保日期
     */
    private Date renewalDate;

    /**
     * 供款年期
     */
    @Schema(description = "供款年期")
    private Integer paymentTerm;

    /**
     * 期交保费
     */
    @Schema(description = "期交保费")
    private BigDecimal paymentPremium;

    /**
     * 是否预缴: 0-否, 1-是
     */
    private Integer isPrepaid;

    /**
     * 预缴年期
     */
    private Integer prepaidTerm;

    /**
     * 预付额
     */
    private String prepaidAmount;

    /**
     * 折扣后预付额
     */
    private String prepaidAmountAfterDiscount;

    /**
     * 保单截止日期
     */
    private Date policyExpirationDate;

    /**
     * 缴费编号
     */
    private String paymentNumber;

    /**
     * 产品名称
     */
    @Schema(description = "产品名称")
    private String productName;

    /**
     * 保险公司
     */
    @Schema(description = "保险公司")
    private String insurer;

    /**
     * 保险公司业务id
     */
    @Schema(description = "保险公司业务id")
    private String insurerBizId;

    /**
     * 对账公司
     */
    @Schema(description = "对账公司")
    private String reconciliationCompany;

    /**
     * 对账公司业务id
     */
    @Schema(description = "对账公司业务id")
    private String reconciliationCompanyBizId;

    /**
     * 新单跟进状态
     */
    @Schema(description = "新单跟进状态 字典值: policy_follow_status")
    private String status;

    /**
     * 保單持有人
     */
    @Schema(description = "保單持有人")
    private String policyHolder;

    /**
     * 受保人
     */
    @Schema(description = "受保人")
    private String insured;

    /**
     * 币种
     */
    @Schema(description = "币种")
    private String currency;

    /**
     * 首期保费（不含徽费，预缴保费）
     */
    @Schema(description = "首期保费（不含徽费，预缴保费）")
    private Object initialPremium;

    /**
     * 转介人
     */
    @Schema(description = "转介人")
    private List<PolicyBroker> brokerList;

    /**
     * 保单信息
     */
//    private Policy policy;


    /**
     * 对象转封装类
     *
     * @param policyFollow
     * @return
     */
    public static PolicyFollowVO objToVo(PolicyFollow policyFollow) {
        if (policyFollow == null) {
            return null;
        }
        PolicyFollowVO policyFollowVO = new PolicyFollowVO();
        BeanUtils.copyProperties(policyFollow, policyFollowVO);
        return policyFollowVO;
    }
}
