package com.yd.csf.api.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class GenerateFortuneDto {

    /**
     * 保单发佣批次ID
     */
    private String batchBizId;

    /**
     * 保单发佣业务id
     */
    private String fortuneBizId;

    /**
     * 保单号
     */
    private String policyNo;

    /**
     * 发佣期数(1=第一年; 2=第二年; 3=第三年; 4=第四年; 5=第五年)
     */
    private Integer fortunePeriod;

    /**
     * 发佣总期数
     */
    private Integer fortuneTotalPeriod;

    /**
     * 转介人 (获得积分的业务员)
     */
    private String broker;

    /**
     * 转介人业务ID (获得积分的业务员)
     */
    private String brokerBizId;

    /**
     * 所属团队
     */
    private String team;

    /**
     * 所属团队业务ID
     */
    private String teamBizId;

    /**
     * 来佣名称
     */
    private String fortuneName;

    /**
     * 发佣类型
     */
    private String fortuneType;

    /**
     * 发佣金额
     */
    private BigDecimal amount;

    /**
     * 发佣币种
     */
    private String currency;

    /**
     * 佣金发放状态 0=待出账 1=可出账 2=已出账
     */
    private String status;

    /**
     * 发佣日期
     */
    private Date payoutDate;

    /**
     * 基本法项目配置表唯一业务ID
     */
    private String ruleItemBizId;

    /**
     * 获得积分业务员绑定的基本法列表对应计算值
     */
    private List<AlgorithmResDto> algorithmResDtoList;
}
