package com.yd.csf.api.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.csf.feign.dto.premiumreconciliation.ApiPremiumReconciliationDto;
import com.yd.csf.feign.request.premiumreconciliation.ApiCalculateRemainingUnpaidAmountRequest;
import com.yd.csf.feign.request.premiumreconciliation.ApiPremiumReconciliationAddRequest;
import com.yd.csf.feign.request.premiumreconciliation.ApiPremiumReconciliationPageRequest;
import com.yd.csf.feign.request.premiumreconciliation.ApiPremiumReconciliationResultEditRequest;
import com.yd.csf.feign.response.premiumreconciliation.ApiCalculateRemainingUnpaidAmountResponse;
import com.yd.csf.feign.response.premiumreconciliation.ApiPremiumReconciliationDetailResponse;
import com.yd.csf.feign.response.premiumreconciliation.ApiPremiumReconciliationPageResponse;
import com.yd.csf.service.model.PremiumReconciliation;

public interface ApiPremiumReconciliationService {
    Result<IPage<ApiPremiumReconciliationPageResponse>> page(ApiPremiumReconciliationPageRequest request);

    Result add(ApiPremiumReconciliationAddRequest request);

    Result edit(ApiPremiumReconciliationDto request);

    Result<ApiPremiumReconciliationDetailResponse> detail(String premiumReconciliationBizId);

    Result<ApiCalculateRemainingUnpaidAmountResponse> calculateRemainingUnpaidAmount(ApiCalculateRemainingUnpaidAmountRequest request);

    Result editResult(ApiPremiumReconciliationResultEditRequest request);

    Result<Boolean> checkReconciliationComplete(String policyNo);

    Result<PremiumReconciliation> checkPremiumReconciliationIsExist(String expectedCommissionRatioBizId);
}
