package com.yd.csf.feign.response.expectedfortune;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

@Data
public class ApiExpectedFortunePageResponse {

    /**
     * 主键ID
     */
    @Schema(description = "expected fortune id")
    private Long id;

    /**
     * 预计出账表唯一业务id
     */
    @Schema(description = "expected fortune biz id")
    private String expectedFortuneBizId;

    /**
     * 应付款类型 R-关联保单应付款 U-非关联保单应付款
     */
    @Schema(description = "应付款类型 R-关联保单应付款 U-非关联保单应付款")
    private String fortuneBizType;

    /**
     * 应付款编号
     */
    @Schema(description = "应付款编号")
    private String payableNo;

    /**
     * 保单号
     */
    @Schema(description = "policy no")
    private String policyNo;

    /**
     * 期交保费
     */
    @Schema(description = "期交保费")
    private BigDecimal premium;

    /**
     * 保险公司 ID
     */
    @Schema(description = "保险公司 ID")
    private String insuranceCompanyBizId;

    /**
     * 产品计划 ID
     */
    @Schema(description = "产品计划 ID")
    private String productLaunchBizId;

    /**
     * 保单信息
     */
    @Schema(description = "policy info")
    private PolicyInfo policy;

    /**
     * 出账期数(1=第一年; 2=第二年; 3=第三年; 4=第四年; 5=第五年)
     */
    @Schema(description = "fortune period")
    private Integer fortunePeriod;

    /**
     * 总期数
     */
    @Schema(description = "fortune total period")
    private Integer fortuneTotalPeriod;

    /**
     * 转介人名称
     */
    @Schema(description = "转介人名称")
    private String broker;

    /**
     * 转介人业务ID
     */
    @Schema(description = "转介人业务ID")
    private String brokerBizId;

    /**
     * 团队名称
     */
    @Schema(description = "团队名称")
    private String team;

    /**
     * 所属团队业务ID
     */
    @Schema(description = "所属团队业务ID")
    private String teamBizId;

    /**
     * 出账项目
     */
    @Schema(description = "出账项目")
    private String fortuneName;

    /**
     * 出账项目类型
     */
    @Schema(description = "出账项目类型")
    private String fortuneType;

    /**
     * 应出账金额
     */
    @Schema(description = "应出账金额")
    private BigDecimal amount;

    /**
     * 出账币种
     */
    @Schema(description = "出账币种")
    private String currency;

    /**
     * 出账状态
     */
    @Schema(description = "出账状态 0=待出账 1=可出帐，待检核 2=完成出账 3=部分出账 4=保留 5=已失效 6=可出账, 已检核 7=未找到当前预计出账对应的来佣 字典值: csf_expected_fortune_status")
    private String status;

    /**
     * 预计出账日期
     */
    @Schema(description = "预计出账日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private LocalDate payoutDate;

     /**
     * 实际出账日期
     */
    @Schema(description = "实际出账日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private LocalDate actualPayoutDate;

    /**
     * 已出账金额
     */
    @Schema(description = "已出账金额")
    private BigDecimal paidAmount;

    /**
     * 待出账金额
     */
    @Schema(description = "待出账金额")
    private BigDecimal unpaidAmount;

    /**
     * 已出账比例 已出账金额/应出账金额
     */
    @Schema(description = "已出账比例 已出账金额/应出账金额")
    private BigDecimal paidRatio;

    /**
     * 待出账比例 待出账金额/应出账金额
     */
    @Schema(description = "待出账比例 待出账金额/应出账金额")
    private BigDecimal unpaidRatio;

    /**
     * 基本法项目配置表唯一业务ID
     */
    @Schema(description = "rule item biz id")
    private String ruleItemBizId;

    /**
     * 创建时间
     */
    @Schema(description = "create time")
    private LocalDateTime createTime;

}
