package com.yd.csf.feign.dto.excel;

import com.yd.common.enums.DictTypeEnum;
import com.yd.common.enums.NoYesEnum;
import com.yd.common.utils.DateUtil;
import com.yd.user.feign.response.sysdict.GetDictItemListByDictTypeResponse;
import lombok.Data;
import org.springframework.beans.BeanUtils;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * Excel-预约资料及计划内容信息
 */
@Data
public class ApiExcelAppointmentPlanDto {

    //============以下是表字段============
    /**
     * 保险公司名称（冗余字段）（产品计划信息表）
     */
    private String companyName;

    /**
     * 基本計劃名稱（产品计划信息表，保险产品名称（中台保险产品名称，冗余））
     */
    private String productName;

    /**
     * 附约计划列表（产品计划-附加险信息表的列表）
     */
    private List<ApiExcelAdditionalDto> additionalDtoList;

    /**
     * 保单币别（货币（字典））（产品计划信息表）
     */
    private String currency;

    /**
     * 付款频率（字典）（产品计划信息表）
     */
    private String paymentFrequency;

    /**
     * 保额（产品计划信息表）
     */
    private BigDecimal sumInsured;

    /**
     * 供款年期（字典）（产品计划信息表）
     */
    private String paymentTerm;

    /**
     * 主險每期保费金额（每期保费）（产品计划信息表）
     */
    private BigDecimal eachIssuePremium;

    /**
     * 是否預繳保費 (如是，請填寫首期保費以外的剩餘保費)（是否预缴保费: 0-否, 1-是（字典）（产品计划信息表））
     */
    private String isPrepay;

    /**
     * 首期保费缴付方式
     * (銀聯/信用卡/銀行現金入數/現金/支票/電匯轉賬/銀行本票/銀行轉賬/銀行自動轉賬/其他)
     * （首期付款方式（字典） ）（产品计划信息表）
     */
    private String initialPaymentMethod;

    /**
     * 续期保费缴付方式
     * (銀聯/信用卡/銀行現金入數/現金/支票/電匯轉賬/銀行本票/銀行轉賬/銀行自動轉賬/其他)
     * （续期付款方式）（产品计划信息表）
     */
    private String renewalPaymentMethod;

    /**
     * 是否參加遞增保障權益/通脹加保權益
     * （是否参加递增保障权益: 0-否, 1-是（字典））（产品计划信息表）
     */
    private String isJoin;

    /**
     * 是否需提前保单生效日
     * （保单生效日）（产品计划信息表）
     */
    private LocalDateTime policyEffectiveDate;

    /**
     * 红利分配方式 (積存生息 / 現金支付 / 扣除保費 / 購買付清保險)
     * 红利分配方式（字典）（产品计划信息表）
     */
    private String dividendDistributionMethod;


    //============以下是excel显示的字段，同上============
    /**
     * 保险公司名称（冗余字段）（产品计划信息表）
     */
    private String planCompanyName;

    /**
     * 基本計劃名稱（产品计划信息表，保险产品名称（中台保险产品名称，冗余））
     */
    private String planProductName;

    /**
     * 保单币别（货币（字典））（产品计划信息表）
     */
    private String planCurrency;

    /**
     * 付款频率（字典）（产品计划信息表）
     */
    private String planPaymentFrequency;

    /**
     * 保额（产品计划信息表）
     */
    private BigDecimal planSumInsured;

    /**
     * 供款年期（字典）（产品计划信息表）
     */
    private String planPaymentTerm;

    /**
     * 主險每期保费金额（每期保费）（产品计划信息表）
     */
    private BigDecimal planEachIssuePremium;

    /**
     * 是否預繳保費 (如是，請填寫首期保費以外的剩餘保費)（是否预缴保费: 0-否, 1-是（字典）（产品计划信息表））
     */
    private String planIsPrepay;

    /**
     * 首期保费缴付方式
     * (銀聯/信用卡/銀行現金入數/現金/支票/電匯轉賬/銀行本票/銀行轉賬/銀行自動轉賬/其他)
     * （首期付款方式（字典） ）（产品计划信息表）
     */
    private String planInitialPaymentMethod;

    /**
     * 续期保费缴付方式
     * (銀聯/信用卡/銀行現金入數/現金/支票/電匯轉賬/銀行本票/銀行轉賬/銀行自動轉賬/其他)
     * （续期付款方式）（产品计划信息表）
     */
    private String planRenewalPaymentMethod;

    /**
     * 是否參加遞增保障權益/通脹加保權益
     * （是否参加递增保障权益: 0-否, 1-是（字典））（产品计划信息表）
     */
    private String planIsJoin;

    /**
     * 是否需提前保单生效日
     * （保单生效日）（产品计划信息表）
     */
    private String planPolicyEffectiveDate;

    /**
     * 红利分配方式 (積存生息 / 現金支付 / 扣除保費 / 購買付清保險)
     * 红利分配方式（字典）（产品计划信息表）
     */
    private String planDividendDistributionMethod;

    /**
     * 重新赋值ApiExcelAppointmentPlanDto
     * @param dto
     * @return
     */
    public static ApiExcelAppointmentPlanDto setApiExcelAppointmentPlanDto(ApiExcelAppointmentPlanDto dto,
                                                                           List<GetDictItemListByDictTypeResponse> dictTypeResponses) {
        ApiExcelAppointmentPlanDto mainDto = new ApiExcelAppointmentPlanDto();
        BeanUtils.copyProperties(dto,mainDto);
        mainDto.setPlanCompanyName(dto.getCompanyName());
        mainDto.setPlanCurrency(dto.getCurrency());
        mainDto.setPlanDividendDistributionMethod(dto.getDividendDistributionMethod());
        mainDto.setPlanEachIssuePremium(dto.getEachIssuePremium());
        mainDto.setPlanInitialPaymentMethod(dto.getInitialPaymentMethod());
        mainDto.setPlanIsJoin(dto.getIsJoin());
        mainDto.setPlanIsPrepay(NoYesEnum.getLabelByValue(dto.getIsPrepay()));
        //付款频率（字典）（产品计划信息表）
        mainDto.setPlanPaymentFrequency(GetDictItemListByDictTypeResponse.getItemLabel(dictTypeResponses,
                DictTypeEnum.CSF_AP_FREQUENCY.getItemValue(),dto.getPaymentFrequency()));
        mainDto.setPlanPaymentTerm(dto.getPaymentTerm());
        //保单生效日（产品计划信息表）
        mainDto.setPlanPolicyEffectiveDate(DateUtil.getyyyyMMdd(dto.getPolicyEffectiveDate()));
        mainDto.setPlanProductName(dto.getProductName());
        //续期保费缴付方式（字典）（产品计划信息表）
        mainDto.setPlanRenewalPaymentMethod(GetDictItemListByDictTypeResponse.getItemLabel(dictTypeResponses,
                DictTypeEnum.CSF_AP_FIRST_ISSUE.getItemValue(),dto.getRenewalPaymentMethod()));
        mainDto.setPlanSumInsured(dto.getSumInsured());
        return mainDto;
    }
}
