package com.yd.csf.feign.client.appointment;

import com.yd.common.result.Result;
import com.yd.csf.feign.dto.appointment.ApiAppointmentInfoDto;
import com.yd.csf.feign.dto.appointment.ApiProductPlanAdditionalInfoDto;
import com.yd.csf.feign.fallback.appointment.ApiAppointmentFeignFallbackFactory;
import com.yd.csf.feign.request.appointment.*;
import com.yd.csf.feign.response.appointment.ApiAppointmentAddResponse;
import com.yd.csf.feign.response.appointment.ApiAppointmentDetailResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotBlank;

/**
 * 香港保险服务-预约信息Feign客户端
 */
@FeignClient(name = "yd-csf-api", fallbackFactory = ApiAppointmentFeignFallbackFactory.class)
public interface ApiAppointmentFeignClient {

    /**
     * 预约分页查询
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiAppointmentPageRequest request);

    /**
     * 预约详情（聚合信息详情）
     * @param appointmentBizId
     * @return
     */
    @GetMapping("/detail")
    Result<ApiAppointmentDetailResponse> detail(@NotBlank(message = "预约信息主表唯一业务ID不能为空") @RequestParam(value = "appointmentBizId") String appointmentBizId);

    /**
     * 预约主体信息详情（单个对象详情）
     * @param appointmentBizId
     * @return
     */
    @GetMapping("/main/detail")
    Result<ApiAppointmentInfoDto> mainDetail(@NotBlank(message = "预约信息主表唯一业务ID不能为空") @RequestParam(value = "appointmentBizId") String appointmentBizId);

    /**
     * 新增预约提交 (聚合信息新增预约提交)
     * @param request
     * @return
     */
    @PostMapping("/add")
    Result<ApiAppointmentAddResponse> add(@Validated @RequestBody ApiAppointmentAddRequest request);

    /**
     * 新增预约暂存 (聚合信息新增预约暂存)
     * @param request
     * @return
     */
    @PostMapping("/add/storage")
    Result addStorage(@Validated @RequestBody ApiAppointmentAddStorageRequest request);

    /**
     * 编辑预约提交 (聚合信息编辑预约提交)
     * @param request
     * @return
     */
    @PutMapping("/edit")
    Result edit(@Validated @RequestBody ApiAppointmentEditRequest request);

    /**
     * 确定预约时间提交 (流程流转到新单跟进)
     * @param request
     * @return
     */
    @PutMapping("/edit/confirm/time")
    Result editConfirmTime(@Validated @RequestBody ApiAppointmentEditConfirmTimeRequest request);

    /**
     * 单个对象编辑-编辑预约主体信息
     * @param apiAppointmentInfoDto
     * @return
     */
    @PutMapping("/single/edit")
    Result singleEdit(@Validated @RequestBody ApiAppointmentInfoDto apiAppointmentInfoDto);

    /**
     * 预约编辑关联FNA
     * @param request
     * @return
     */
    @PutMapping("/edit/fna")
    Result editFna(@Validated @RequestBody ApiAppointmentEditFnaRequest request);

    /**
     * 预约解除关联FNA
     * @param request
     * @return
     */
    @PutMapping("/remove/fna")
    Result removeFna(@Validated @RequestBody ApiAppointmentRemoveFnaRequest request);

    /**
     * 预约编辑关联计划书
     * @param request
     * @return
     */
    @PutMapping("/edit/proposal")
    Result editProposal(@Validated @RequestBody ApiAppointmentEditProposalRequest request);

    /**
     * 预约解除关联计划书
     * @param request
     * @return
     */
    @PutMapping@PostMapping("/remove/proposal")
    Result removeProposal(@Validated @RequestBody ApiAppointmentRemoveProposalRequest request);

    /**
     * 预约编辑转保声明
     * @param request
     * @return
     */
    @PutMapping("/edit/policy/transfer")
    Result editPolicyTransfer(@Validated @RequestBody ApiPolicyTransferRequest request);
}
