package com.yd.csf.service.vo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
public class FortuneVO implements Serializable {

    /**
     * 保单发佣业务id
     */
    private String fortuneBizId;

    /**
     * 保单号
     */
    private String policyNo;

    /**
     * 发佣期数(1=第一年; 2=第二年; 3=第三年; 4=第四年; 5=第五年)
     */
    private Integer fortunePeriod;

    /**
     * 发佣总期数
     */
    private Integer fortuneTotalPeriod;

    /**
     * 转介人
     */
    private String broker;

    /**
     * 转介人业务ID
     */
    private String brokerBizId;

    /**
     * 所属团队
     */
    private String team;

    /**
     * 所属团队业务ID
     */
    private String teamBizId;

    /**
     * 个人职级佣金率
     */
    private BigDecimal gradeCommissionRate;

    /**
     * 多个代理人财富分摊比例
     */
    private BigDecimal shareRate;

    /**
     * 来佣名称
     */
    private String fortuneName;

    /**
     * 发佣类型
     */
    private String fortuneType;

    /**
     * 发佣金额
     */
    private BigDecimal amount;

    /**
     * 发佣币种
     */
    private String currency;

    /**
     * 佣金发放状态 0=暂不可发 1=可发放 2=已发并关账
     */
    private String status;

    /**
     * 发佣日期
     */
    private Date payoutDate;

    /**
     * 是否含税 0=No, 1=Yes
     */
    private Integer isTax;

    /**
     * 应缴税额
     */
    private BigDecimal taxAmount;

    /**
     * 税后发佣
     */
    private BigDecimal netAmount;

    /**
     * 薪资单业务id
     */
    private String salaryBizId;

    /**
     * 基本法id
     */
    private String baseRuleBizId;

    /**
     * 计算规则id
     */
    private String settlementBizId;

    /**
     * 计算公式
     */
    private String calculationFormula;

    /**
     * 通用备注
     */
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    private String creatorId;

    /**
     * 更新人ID
     */
    private String updaterId;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

    private static final long serialVersionUID = 1L;
}
