package com.yd.csf.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

/**
 * 保单表
 * @TableName policy
 */
@TableName(value ="policy")
@Data
public class Policy implements Serializable {
    /**
     * id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 新单跟进唯一业务ID
     */
    private String policyBizId;

    /**
     * 保单号
     */
    private String policyNo;

    /**
     * 用户业务id
     */
    private String userBizId;

    /**
     * 产品计划业务id
     */
    private String productLaunchBizId;

    /**
     * 产品代码
     */
    private String productCode;

    /**
     * 产品名称
     */
    private String productName;

    /**
     * 产品险种
     */
    private String productCate;

    /**
     * 保险公司
     */
    private String insuranceCompany;

    /**
     * 保险公司业务id
     */
    private String insuranceCompanyBizId;

    /**
     * 地区
     */
    private String region;

    /**
     * 保單持有人
     */
    private String policyHolder;

    /**
     * 受保人
     */
    private String insured;

    /**
     * 保额
     */
    private Object sumInsured;

    /**
     * 供款年期（字典）
     */
    private Object paymentTerm;

    /**
     * 付款频率（字典）
     */
    private String paymentFrequency;

    /**
     * 期交保费
     */
    private BigDecimal paymentPremium;

    /**
     * 保单状态
     */
    private String status;

    /**
     * 币种
     */
    private String currency;

    /**
     * 首期保费（不含徽费，预缴保费）
     */
    private Object initialPremium;

    /**
     * 签单日期
     */
    private Date signDate;

    /**
     * 缮发日期
     */
    private Date issueDate;

    /**
     * 生效日期
     */
    private Date effectiveDate;

    /**
     * 核保日期
     */
    private Date underwritingDate;

     /**
     * 冷却期结束日期
     */
    private Date coolingOffEndDate;

     /**
     * 冷却期天数
     */
    private Integer coolingOffDays;

    /**
     * 续保日期
     */
    private Date renewalDate;

    /**
     * 是否预缴: 0-否, 1-是
     */
    private Integer isPrepaid;

    /**
     * 预付额
     */
    private String deductibles;

    /**
     * 预缴年期
     */
    private Integer prepaidTerm;

    /**
     * 首期付款方式（字典）
     */
    private String initialPaymentMethod;

    /**
     * 续期付款方式（字典）
     */
    private String renewalPaymentMethod;

    /**
     * 红利分配方式（字典）
     */
    private String dividendDistributionMethod;

    /**
     * 保单日期回溯: 0-否, 1-是（字典）
     */
    private Integer isBacktrack;

    /**
     * 是否参加递增保障权益: 0-否, 1-是（字典）
     */
    private Integer isJoin;

    /**
     * 对账公司
     */
    private String reconciliationCompany;

    /**
     * 对账公司业务id
     */
    private String reconciliationCompanyBizId;

    /**
     * 转保声明选项(字典)
     */
    private String policyTransfer;

     /**
     * 保单征费
     */
    private String policyLevy;

    /**
     * 缴费宽限期（每期缴费的最大宽限天数）
     */
    private String gracePeriod;

    /**
     * 通用备注
     */
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    private String creatorId;

    /**
     * 更新人ID
     */
    private String updaterId;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}