package com.yd.csf.service.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.alibaba.excel.annotation.write.style.ContentRowHeight;
import com.alibaba.excel.annotation.write.style.HeadRowHeight;
import com.yd.csf.service.model.CommissionExpected;
import lombok.Data;
import org.apache.commons.lang3.ObjectUtils;

import java.math.BigDecimal;
import java.util.Date;

@Data
@ContentRowHeight(15)
@HeadRowHeight(20)
@ColumnWidth(25)
public class CommissionExpectedExportDTO {

    @ExcelProperty("应收账款编号")
    @ColumnWidth(20)
    private String receivableNo;

    @ExcelProperty("应收款类型")
    private String commissionBizType;

    @ExcelProperty("保单号")
    @ColumnWidth(20)
    private String policyNo;

    @ExcelProperty("对账公司")
    @ColumnWidth(20)
    private String reconciliationCompany;

    @ExcelProperty("佣金期数")
    private Integer commissionPeriod;

    @ExcelProperty("总来佣期数")
    private Integer totalPeriod;

    @ExcelProperty("来佣名称")
    @ColumnWidth(20)
    private String commissionName;

    @ExcelProperty("来佣类型")
    private String commissionType;

    @ExcelProperty("预计入账比例(%)")
    private BigDecimal commissionRatio;

    @ExcelProperty("来佣币种")
    private String currency;

    @ExcelProperty("预计来佣日期")
    @DateTimeFormat("yyyy-MM-dd")
    @ColumnWidth(15)
    private Date commissionDate;

    @ExcelProperty("入账状态")
    private String status;

    @ExcelProperty("入账状态-修改理由")
    @ColumnWidth(30)
    private String statusDesc;

    @ExcelProperty("预计入账金额(HKD)")
    @ColumnWidth(20)
    private BigDecimal expectedAmount;

    @ExcelProperty("已入账金额(HKD)")
    @ColumnWidth(20)
    private BigDecimal paidAmount;

    @ExcelProperty("已入账比例(%)")
    @ColumnWidth(20)
    private BigDecimal paidRatio;

    @ExcelProperty("待入账金额(HKD)")
    @ColumnWidth(20)
    private BigDecimal pendingAmount;

    @ExcelProperty("待入账比例(%)")
    @ColumnWidth(20)
    private BigDecimal pendingRatio;

    @ExcelProperty("备注")
    @ColumnWidth(30)
    private String remark;

    @ExcelProperty("创建时间")
    @DateTimeFormat("yyyy-MM-dd HH:mm:ss")
    @ColumnWidth(20)
    private Date createTime;

    @ExcelProperty("更新时间")
    @DateTimeFormat("yyyy-MM-dd HH:mm:ss")
    @ColumnWidth(20)
    private Date updateTime;

    /**
     * 将对象转换为导出DTO
     */
    public static CommissionExpectedExportDTO convertToExportDTO(CommissionExpected vo) {
        CommissionExpectedExportDTO dto = new CommissionExpectedExportDTO();
        dto.setReceivableNo(vo.getReceivableNo());
        dto.setCommissionBizType(vo.getCommissionBizType());
        dto.setPolicyNo(vo.getPolicyNo());
        dto.setReconciliationCompany(vo.getReconciliationCompany());
        dto.setCommissionPeriod(vo.getCommissionPeriod());
        dto.setTotalPeriod(vo.getTotalPeriod());
        dto.setCommissionName(vo.getCommissionName());
        dto.setCommissionType(vo.getCommissionType());
        dto.setCommissionRatio(vo.getCommissionRatio());
        dto.setCurrency(vo.getCurrency());
        dto.setCommissionDate(vo.getCommissionDate());
        dto.setStatus(getStatusText(vo.getStatus()));
        dto.setExpectedAmount(vo.getExpectedAmount());
        dto.setPaidAmount(vo.getPaidAmount());
        dto.setPaidRatio(vo.getPaidRatio());

        BigDecimal paidAmount1 = ObjectUtils.defaultIfNull(vo.getPaidAmount(), BigDecimal.ZERO);
        BigDecimal paidRatio1 = ObjectUtils.defaultIfNull(vo.getPaidRatio(), BigDecimal.ZERO);
        // 待入账比例、待入账金额
        if (vo.getCommissionRatio() != null) {
            dto.setPaidRatio(paidRatio1);
            dto.setPendingRatio(vo.getCommissionRatio().subtract(paidRatio1));
            if (vo.getExpectedAmount() != null) {
                dto.setPaidAmount(paidAmount1);
                dto.setPendingAmount(vo.getExpectedAmount().subtract(paidAmount1));
            }
        } else if (vo.getAmount() != null) {
            dto.setPaidAmount(paidAmount1);
            dto.setPendingAmount(vo.getAmount().subtract(paidAmount1));
        }

        dto.setRemark(vo.getRemark());
        dto.setCreateTime(vo.getCreateTime());
        dto.setUpdateTime(vo.getUpdateTime());

        return dto;
    }

    /**
     * 获取状态文本
     */
    public static String getStatusText(String status) {
        if (status == null) return "未知";
        switch (status) {
            case "0":
                return "待入账";
            case "1":
                return "完成入账";
            case "2":
                return "部分入账";
            case "3":
                return "已失效";
            default:
                return "未知";
        }
    }
}
