package com.yd.csf.feign.fallback.additional;

import com.yd.common.result.Result;
import com.yd.csf.feign.client.additional.ApiAdditionalFeignClient;
import com.yd.csf.feign.dto.appointment.ApiProductPlanAdditionalInfoDto;
import com.yd.csf.feign.request.additional.ApiAdditionalPageRequest;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

import javax.validation.constraints.NotBlank;

/**
 * 香港保险服务-产品计划-附加险信息Feign降级处理
 */
@Slf4j
@Component
public class ApiAdditionalFeignFallbackFactory implements FallbackFactory<ApiAdditionalFeignClient> {
    @Override
    public ApiAdditionalFeignClient create(Throwable cause) {
        return new ApiAdditionalFeignClient() {
            @Override
            public Result page(ApiAdditionalPageRequest request) {
                return null;
            }

            @Override
            public Result add(ApiProductPlanAdditionalInfoDto apiProductPlanAdditionalInfoDto) {
                return null;
            }

            @Override
            public Result edit(ApiProductPlanAdditionalInfoDto apiProductPlanAdditionalInfoDto) {
                return null;
            }

            @Override
            public Result<ApiProductPlanAdditionalInfoDto> detail(String additionalBizId) {
                return null;
            }

            @Override
            public Result del(String additionalBizId) {
                return null;
            }
        };
    }
}
