package com.yd.csf.service.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@Data
public class CommissionExpectedAddDto {
    /**
     * 预计来佣业务id
     */
    @Schema(description = "预计来佣业务id")
    private String commissionExpectedBizId;

    /**
     * 新单跟进业务id
     */
    @Schema(description = "新单跟进业务id", requiredMode = Schema.RequiredMode.REQUIRED)
    private String policyBizId;

    /**
     * 应收款类型 R=关联保单应收单 U=非关联保单应收单
     */
    @Schema(description = "应收款类型 R=关联保单应收单 U=非关联保单应收单", requiredMode = Schema.RequiredMode.REQUIRED)
    private String commissionBizType;

    /**
     * 关联保单号
     */
    @Schema(description = "关联保单号")
    private String policyNo;

    /**
     * 对账公司
     */
    @Schema(description = "对账公司")
    private String reconciliationCompany;

    /**
     * 对账公司编码
     */
    @Schema(description = "对账公司编码")
    private String reconciliationCompanyCode;

    /**
     * 对账公司业务id
     */
    @Schema(description = "对账公司业务id")
    private String reconciliationCompanyBizId;

    /**
     * 佣金期数
     */
    @Schema(description = "佣金期数")
    private Integer commissionPeriod;

    /**
     * 总期数
     */
    @Schema(description = "总期数")
    private Integer totalPeriod;

    /**
     * 入账项目(1:销售拥金;2:销售奖金;3:销售津贴;4:续期佣金;5:服务津贴;等等)
     */
    @Schema(description = "入账项目(1:销售拥金;2:销售奖金;3:销售津贴;4:续期佣金;5:服务津贴;等等)")
    private String commissionName;

    /**
     * 入账项目类型(1:销售拥金;2:销售奖金;3:销售津贴;4:续期佣金;5:服务津贴;等等)
     */
    @Schema(description = "入账项目类型(1:销售拥金;2:销售奖金;3:销售津贴;4:续期佣金;5:服务津贴;等等)")
    private String commissionType;

    /**
     * 入账比例 (%)
     */
    @Schema(description = "入账比例 (%)")
    private BigDecimal commissionRatio;

    /**
     * 入账币种
     */
    @Schema(description = "入账币种")
    private String currency;

    /**
     * 入账金额
     */
    @Schema(description = "入账金额")
    private BigDecimal amount;

    /**
     * 入账日 (估)
     */
    @Schema(description = "入账日 (估) format:yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date commissionDate;

    /**
     * 入账日 (实)
     */
    @Schema(description = "入账日 (实) format:yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date actualCommissionDate;

    /**
     * 入账状态 0=待入账 1=完成入账 2=部分入账 3=已失效
     */
    @Schema(description = "入账状态 0=待入账 1=完成入账 2=部分入账 3=已失效 字典值: csf_expected_commission_status")
    private String status;

    /**
     * 备注
     */
    @Schema(description = "备注")
    private String remark;
}
