package com.yd.csf.service.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yd.csf.service.dto.PolicyFollowUpdateDto;
import com.yd.csf.service.enums.PolicyFollowStatusEnum;
import com.yd.csf.service.model.PolicyFollow;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.springframework.beans.BeanUtils;

import java.io.Serializable;
import java.util.*;

/**
 * 新单跟进视图
 */
@Data
public class PolicyFollowVO implements Serializable {

    private static final long serialVersionUID = 1L;

    @Schema(description = "policy follow id")
    private Long id;

    /**
     * 新单跟进唯一业务ID
     */
    @Schema(description = "新单跟进唯一业务ID")
    private String policyBizId;

    /**
     * 保单号
     */
    @Schema(description = "保单号")
    private String policyNo;

    /**
     * 新单跟进状态
     */
    @Schema(description = "新单跟进状态")
    private String status;

    /**
     * 预约信息主表唯一业务ID
     */
    @Schema(description = "预约信息主表唯一业务ID")
    private String appointmentBizId;

    /**
     * 预约编号
     */
    @Schema(description = "预约编号")
    private String appointmentNo;

    /**
     * 客户业务id
     */
    @Schema(description = "客户业务id")
    private String customerBizId;

    /**
     * 签单日
     */
    @Schema(description = "签单日", format = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate;

    /**
     * 最晚缴费日
     */
    @Schema(description = "最晚缴费日", format = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date latestPaymentDate;

    /**
     * 保單持有人
     */
    @Schema(description = "投保人")
    private String policyHolder;

    /**
     * 受保人
     */
    @Schema(description = "受保人")
    private String insured;

    /**
     * 受保人业务id
     */
    @Schema(description = "受保人业务id")
    private String insuredBizId;

    /**
     * 产品计划唯一业务ID
     */
    @Schema(description = "产品计划唯一业务ID")
    private String productLaunchBizId;

    /**
     * 产品计划
     */
    @Schema(description = "产品计划")
    private String productName;

    /**
     * 保险公司
     */
    @Schema(description = "保险公司")
    private String insuranceCompany;

    /**
     * 保险公司业务id
     */
    @Schema(description = "保险公司业务id")
    private String insuranceCompanyBizId;

    /**
     * 对象转封装类
     *
     * @param policyFollow
     * @return
     */
    public static PolicyFollowVO objToVo(PolicyFollow policyFollow) {
        if (policyFollow == null) {
            return null;
        }
        PolicyFollowVO policyFollowVO = new PolicyFollowVO();
        BeanUtils.copyProperties(policyFollow, policyFollowVO);
        // 状态映射为中文
        policyFollowVO.setStatus(PolicyFollowStatusEnum.mapStatusToLabel(policyFollow.getStatus()));

        return policyFollowVO;
    }
}
