package com.yd.csf.feign.request.agentreferralrelation;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.List;

@Data
public class ApiAgentReferralRelationSaveRequest {

    /**
     * 所属租户唯一业务ID（冗余）
     */
    private String tenantBizId;

    /**
     * 所属项目唯一业务ID（冗余）
     */
    private String projectBizId;

    /**
     * 被推荐人ID（客户端用户表唯一业务ID）列表
     */
    @NotEmpty(message = "被推荐人ID列表不能为空")
    private List<String> agentIdList;

    /**
     * 推荐人ID（客户端用户表唯一业务ID，如果是PC，这里就是sys_user的用户ID）
     */
    @NotBlank(message = "推荐人ID不能为空")
    private String referrerId;

    /**
     * 推荐人账号（客户端用户表手机号，如果是PC，这里就是sys_user的用户名）
     */
    private String referrerAccount;

    /**
     * 推荐来源（PC、小程序等，字典，PC就是中台加入申请的）
     */
    @NotBlank(message = "推荐来源不能为空")
    private String source;
}
