package com.yd.csf.feign.client.premiumremittance;

import com.yd.common.result.Result;
import com.yd.csf.feign.dto.premiumremittance.ApiPremiumRemittanceDto;
import com.yd.csf.feign.fallback.premiumremittance.ApiPremiumRemittanceFeignFallbackFactory;
import com.yd.csf.feign.request.premiumremittance.ApiPremiumRemittancePageRequest;
import com.yd.csf.feign.request.premiumremittancefile.ApiPremiumRemittanceFilePageRequest;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import javax.validation.constraints.NotBlank;

/**
 * 香港保险服务-保费对账汇款记录信息Feign客户端
 */
@FeignClient(name = "yd-csf-api", fallbackFactory = ApiPremiumRemittanceFeignFallbackFactory.class)
public interface ApiPremiumRemittanceFeignClient {

    /**
     * 分页列表查询-保费对账汇款记录信息
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiPremiumRemittancePageRequest request);

    /**
     * 添加-单个保费对账汇款记录信息
     * @param request
     * @return
     */
    @PostMapping("/add")
    Result add(@Validated @RequestBody ApiPremiumRemittanceDto request);

    /**
     * 编辑-单个保费对账汇款记录信息
     * @param request
     * @return
     */
    @PutMapping("/edit")
    Result edit(@Validated @RequestBody ApiPremiumRemittanceDto request);

    /**
     * 详情-保费对账汇款记录信息
     * @param premiumRemittanceBizId 保费对账-汇款记录表唯一业务ID
     * @return
     */
    @GetMapping("/detail")
    Result<ApiPremiumRemittanceDto> detail(@NotBlank(message = "保费对账-汇款记录表唯一业务ID能为空") @RequestParam(value = "premiumRemittanceBizId") String premiumRemittanceBizId);

    /**
     * 删除-单个保费对账汇款记录信息
     * @param premiumRemittanceBizId
     * @return
     */
    @DeleteMapping("/del")
    Result del(@NotBlank(message = "保费对账-汇款记录表唯一业务ID能为空") @RequestParam(value = "premiumRemittanceBizId") String premiumRemittanceBizId);
}
