package com.yd.csf.service.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 更新预计入账请求
 */
@Data
public class CommissionExpectedUpdateRequest implements Serializable {
    /**
     * 预计入账业务id
     */
    @Schema(description = "预计入账业务id")
    private String commissionExpectedBizId;

    /**
     * 入账状态
     */
    @Schema(description = "入账状态 字典值: csf_expected_commission_status")
    private String status;

    /**
     * 新单跟进业务id
     */
    @Schema(description = "新单跟进业务id", requiredMode = Schema.RequiredMode.REQUIRED)
    private String policyBizId;

    /**
     * 保单号
     */
    @Schema(description = "保单号")
    private String policyNo;

    /**
     * 对账公司
     */
    @Schema(description = "对账公司")
    private String reconciliationCompany;

    /**
     * 对账公司业务id
     */
    @Schema(description = "对账公司业务id")
    private String reconciliationCompanyBizId;

    /**
     * 佣金期数(1=第一年; 2=第二年; 3=第三年; 4=第四年; 5=第五年)
     */
    @Schema(description = "佣金期数(1=第一年; 2=第二年; 3=第三年; 4=第四年; 5=第五年)")
    private Integer commissionPeriod;

    /**
     * 总入账期数
     */
    @Schema(description = "总入账期数")
    private Integer totalPeriod;

    /**
     * 入账名称(1:销售拥金;2:销售奖金;3:销售津贴;4:续期佣金;5:服务津贴;等等)
     */
    @Schema(description = "入账名称(1:销售拥金;2:销售奖金;3:销售津贴;4:续期佣金;5:服务津贴;等等)")
    private String commissionName;

    /**
     * 入账类型(1:销售拥金;2:销售奖金;3:销售津贴;4:续期佣金;5:服务津贴;等等)
     */
    @Schema(description = "入账类型(1:销售拥金;2:销售奖金;3:销售津贴;4:续期佣金;5:服务津贴;等等)")
    private String commissionType;

    /**
     * 入账比例
     */
    @Schema(description = "入账比例")
    private BigDecimal commissionRatio;

    /**
     * 入账金额
     */
    @Schema(description = "入账金额")
    private BigDecimal amount;

    /**
     * 入账币种
     */
    @Schema(description = "入账币种")
    private String currency;

    /**
     * 入账日期
     */
    @Schema(description = "入账日期 format:yyyy-MM-dd")
    private Date commissionDate;

    /**
     * 备注
     */
    @Schema(description = "备注")
    private String remark;

    private static final long serialVersionUID = 1L;
}