package com.yd.csf.api.dto;

import com.alibaba.excel.annotation.ExcelProperty;
import com.yd.common.enums.CommonEnum;
import com.yd.common.utils.RandomStringGenerator;
import com.yd.csf.service.enums.CommissionStatusEnum;
import com.yd.csf.service.model.Commission;
import com.yd.csf.service.model.CommissionExpected;
import lombok.Data;
import org.springframework.beans.BeanUtils;

import java.math.BigDecimal;
import java.util.Date;

@Data
public class CommissionExcelDTO {
    @ExcelProperty("入账检核年月")
    private String reconciliationYearMonth;

    @ExcelProperty("应收账款编号")
    private String receivableNo;

    @ExcelProperty("保单号")
    private String policyNo;

    @ExcelProperty("保费")
    private String premium;

    @ExcelProperty("对账公司")
    private String reconciliationCompany;

    @ExcelProperty("当前来佣期数")
    private Integer commissionPeriod;

    @ExcelProperty("总来佣期数")
    private Integer totalPeriod;

    @ExcelProperty("来佣项目")
    private String commissionName;

    @ExcelProperty("来佣金额")
    private BigDecimal amount;

    @ExcelProperty("来佣币种")
    private String currency;

    @ExcelProperty("结算汇率")
    private String exchangeRate;

    @ExcelProperty("来佣日期")
    private Date commissionDate;

    @ExcelProperty("备注")
    private String remark;

    /**
     * 数据转换
     */
    public static Commission convertToEntity(CommissionExcelDTO data, String loginUserId) {
        Commission entity = new Commission();
        // 字段映射
        entity.setReconciliationYearMonth(data.getReconciliationYearMonth());
        entity.setReceivableNo(data.getReceivableNo());
        entity.setPolicyNo(data.getPolicyNo());
        entity.setPremium(data.getPremium());
        entity.setCommissionBizId(RandomStringGenerator.generateBizId16(CommonEnum.UID_TYPE_COMMISSION.getCode()));
        entity.setReconciliationCompany(data.getReconciliationCompany());
        entity.setCommissionPeriod(data.getCommissionPeriod());
        entity.setTotalPeriod(data.getTotalPeriod());
        entity.setCommissionName(data.getCommissionName());
        entity.setAmount(data.getAmount());
        entity.setCurrency(data.getCurrency());
        entity.setExchangeRate(data.getExchangeRate());
        entity.setCommissionDate(data.getCommissionDate());
        entity.setRemark(data.getRemark());
        entity.setStatus(null);
        entity.setCreatorId(loginUserId);
        entity.setUpdaterId(loginUserId);
        entity.setCreateTime(new Date());
        entity.setUpdateTime(new Date());
        return entity;
    }

    /**
     * Excel数据转 预计来佣实体
     *
     * @param data
     * @param loginUserId
     * @return
     */
    public static CommissionExpected convertToCommissionExpectedObj(CommissionExcelDTO data, String loginUserId) {
        CommissionExpected entity = new CommissionExpected();
        // 字段映射
        entity.setPolicyNo(data.getPolicyNo());
        entity.setCommissionExpectedBizId(RandomStringGenerator.generateBizId16("commission_expected"));
        entity.setReconciliationCompany(data.getReconciliationCompany());
        entity.setCommissionPeriod(data.getCommissionPeriod());
        entity.setTotalPeriod(data.getTotalPeriod());
        entity.setCommissionName(data.getCommissionName());
        entity.setCommissionRatio(data.getAmount());
        entity.setCurrency(data.getCurrency());
        entity.setCommissionRatio(null);
        entity.setCommissionDate(data.getCommissionDate());
        entity.setRemark(data.getRemark());
        entity.setStatus("0");
        entity.setCreatorId(loginUserId);
        entity.setUpdaterId(loginUserId);
        entity.setCreateTime(new Date());
        entity.setUpdateTime(new Date());
        return entity;
    }
}
