package com.yd.csf.service.enums;

import org.apache.commons.lang3.ObjectUtils;

/**
 * 新单跟进状态枚举
 */
public enum PolicyFollowStatusEnum {
    PENDING_SIGN("待签单", "PENDING_SIGNATURE"),
    SIGNED("已签单", "SIGNED_ORDER"),
    WAITING_PAYMENT("等待汇款", "WAITING_REMITTANCE"),
    PREMIUM_RECONCILING("首期保费对账中", "IN_RECONCILIATION"),
    PREMIUM_RECONCILED_UNDERWRITING("保费对账成功,核保中", "UNDERWRITING_PROGRESS"),
    EFFECTIVE("生效", "TAKE_EFFECT"),
    CANCELLED("取消投保", "CANCEL_COVERAGE"),
    DECLINED("拒保", "REJECTION_INSURANCE"),
    DELAYED_UNDERWRITING("延缓承保", "DELAY_UNDERWRITING"),
    LAPSED("失效", "FAILURE"),
    CLOSED("关闭", "CLOSE"),
    QX_YY("取消预约", "QX_YY"),
    ;

    //字典项标签（名称）
    private String itemLabel;
    //字典项值
    private String itemValue;

    //构造函数
    PolicyFollowStatusEnum(String itemLabel, String itemValue) {
        this.itemLabel = itemLabel;
        this.itemValue = itemValue;
    }

    /**
     * 根据 itemLabel 获取枚举
     *
     * @param itemLabel
     * @return
     */
    public static PolicyFollowStatusEnum getEnumByItemLabel(String itemLabel) {
        if (ObjectUtils.isEmpty(itemLabel)) {
            return null;
        }
        for (PolicyFollowStatusEnum anEnum : PolicyFollowStatusEnum.values()) {
            if (anEnum.itemLabel.equals(itemLabel)) {
                return anEnum;
            }
        }
        return null;
    }

    public String getItemLabel() {
        return itemLabel;
    }

    public String getItemValue() {
        return itemValue;
    }

    /**
     * 根据 value 获取枚举
     *
     * @param value
     * @return
     */
    public static PolicyFollowStatusEnum getEnumByValue(String value) {
        if (ObjectUtils.isEmpty(value)) {
            return null;
        }
        for (PolicyFollowStatusEnum anEnum : PolicyFollowStatusEnum.values()) {
            if (anEnum.getItemValue().equals(value)) {
                return anEnum;
            }
        }
        return null;
    }

    /**
     * 状态映射为中文
     *
     * @param status
     * @return
     */
    public static String mapStatusToLabel(String status) {
        PolicyFollowStatusEnum policyFollowStatusEnum = getEnumByValue(status);
        if (policyFollowStatusEnum == null) {
            return "";
        }
        return policyFollowStatusEnum.getItemLabel();
    }

}
