package com.yd.csf.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.csf.feign.request.team.ApiTeamPageRequest;
import com.yd.csf.feign.response.team.ApiTeamPageResponse;
import com.yd.csf.service.dto.TeamDto;
import com.yd.csf.service.model.Team;
import com.yd.csf.service.dao.TeamMapper;
import com.yd.csf.service.model.Variable;
import com.yd.csf.service.service.ITeamService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 团队表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-10-15
 */
@Service
public class TeamServiceImpl extends ServiceImpl<TeamMapper, Team> implements ITeamService {

    @Override
    public IPage<ApiTeamPageResponse> page(Page<ApiTeamPageResponse> page,
                                           ApiTeamPageRequest request) {
        return baseMapper.page(page,request);
    }

    @Override
    public List<Team> queryList(TeamDto dto) {
        List<Team> list = baseMapper.selectList(new LambdaQueryWrapper<Team>()
                .like(StringUtils.isNotBlank(dto.getTeamName()),Team::getTeamName,dto.getTeamName())
        );
        return list;
    }
}
