package com.yd.csf.feign.response.appointment;

import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 预约分页查询出参
 */
@Data
public class ApiAppointmentPageResponse {

    /**
     * 预约信息主表唯一业务ID
     */
    private String appointmentBizId;

    /**
     * 预约编号
     */
    private String appointmentNo;

    /**
     * 用户（租户名称）
     */
    private String tenantName;

    /**
     * 产品名称（显示内容-产品计划表：产品图标（中台产品表）+产品名称（供款年期）（产品计划表））（冗余的产品id就可以查询到）
     */
    private String productName;

    /**
     * 保险公司（显示内容-产品计划表：产品所属保险公司（中台产品表）+产品所属公司的所在地（中台产品表））（冗余的产品id就可以查询到）
     */
    private String companyName;

    /**
     * 投保人（显示内容：投保人表的名字+名字英文）
     */
    private String policyholder;

    /**
     * 受保人（显示内容：受保人表的名字+名字英文）
     */
    private String insurant;

    /**
     * 供款年期（字典）（显示内容-产品计划表：供款年期，单位年）
     */
    private String paymentTerm;

    /**
     * 预约状态: 0-暂存 1-待预约, 2-待签署 3-已签署 4-已取消（字典）
     */
    private Integer status;

    /**
     * 每期保费（显示内容-产品计划表：每期保费）
     */
    private BigDecimal eachIssuePremium;

    /**
     * 货币（字典）（显示内容-产品计划表：货币）
     */
    private String currency;

    /**
     * 时间（显示-预约信息表：意向预约时间+业务代表1 姓名+业务代表1 电话号码+签单地址） TODO
     */
    private String time;

    /**
     * 业务代表1姓名（业务员）
     */
    private String businessRepresentName1;

    /**
     * 创建人ID
     */
    private String creatorId;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 创建人用户名
     */
    private String creatorName;

    /**
     * 意向预约时间
     */
    private LocalDateTime intentionAppointmentTime;

    /**
     * 确定预约时间
     */
    private LocalDateTime confirmAppointmentTime;
}
