package com.yd.csf.feign.dto.appointmentfile;

import com.yd.oss.feign.annotation.PdfField;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * 预约行程单PDF字段映射实体类
 */
@Data
public class ItineraryDto {

    /**
     * 集合时间（到港时间）
     */
    @PdfField("arrivalTime")
    private String arrivalTime;

    /**
     * 集合地点（字典）（会面地点）
     */
    @PdfField("meetingPoint")
    private String meetingPoint;

    /**
     * 意向地点（签单地址）
     */
    @PdfField("signingAddress")
    private String signingAddress;

    /**
     * 业务代表1姓名
     */
    @PdfField("businessRepresentName1")
    private String businessRepresentName1;

    /**
     * 业务代表1电话号码区号
     */
    @PdfField("businessRepresentMobile1Code")
    private String businessRepresentMobile1Code;

    /**
     * 业务代表1电话号码
     */
    @PdfField("businessRepresentMobile1")
    private String businessRepresentMobile1;

    /**
     * 咨询人（客户表-客户姓名）
     */
    @PdfField("name")
    private String name;

    /**
     * 受保人（受保人姓名）
     */
    @PdfField("insurantName")
    private String insurantName;

    /**
     * 意向缴费年期（产品计划-供款年期（字典））
     */
    @PdfField("paymentTerm")
    private String paymentTerm;

    /**
     * 意向年缴保费（产品计划-每期保费）
     */
    @PdfField("eachIssuePremium")
    private String eachIssuePremium;

    /**
     * 保单证费（产品计划-保单证费）
     */
    @PdfField("policyFee")
    private String policyFee;

    /**
     * 币种（产品计划-货币（字典））
     */
    @PdfField("currency")
    private String currency;

    /**
     * 意向咨询产品（产品计划-保险产品名称（中台保险产品名称，冗余））
     */
    @PdfField("productName")
    private String productName;

    /**
     * 合计金额（产品计划首期保费+保单证费）
     */
    @PdfField("total")
    private String total;

    /**
     * 客户姓名前缀
     */
    @PdfField("np")
    private String np;

    /**
     * 备注
     */
    @PdfField("remark")
    private String remark;

    /**
     * 确定预约时间（年月日，时分）
     */
    @PdfField("confirmAppointmentTime")
    private String confirmAppointmentTime;
}
