package com.yd.csf.service.vo;

import cn.hutool.json.JSONUtil;

import com.yd.csf.service.dto.*;
import com.yd.csf.service.model.FnaForm;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.springframework.beans.BeanUtils;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * Fna表单视图
 *
 */
@Data
public class FnaFormVO implements Serializable {

    /**
     * id
     */
    private Long id;

    /**
     * fna唯一业务ID
     */
    @Schema(description = "fna唯一业务ID")
    private String fnaFormBizId;


    /**
     * 客户唯一业务ID
     */
    @Schema(description = "客户唯一业务ID")
    private String customerBizId;

    /**
     * 个人资料
     */
    @Schema(description = "个人资料")
    private PersonalData personalData;

    /**
     * 家庭状况
     */
    @Schema(description = "家庭状况")
    private List<FamilyMember> familyMembers;

    /**
     * 保单持有人个人已有保障
     */
    @Schema(description = "保单持有人个人已有保障")
    private List<ExistingSecurity> existingSecurityOwner;

    /**
     * 受保人个人已有保障
     */
    @Schema(description = "受保人个人已有保障")
    private List<ExistingSecurity> existingSecurityInsured;

    /**
     * 平均月收入
     */
    @Schema(description = "在过去24个月里，你从所有所得的收入来源所得的平均每月收入为?(包括薪金、花红、佣金、其他薪酬红利、银行存款利息、债券利息及股息等")
    private String monthlyIncome;

    /**
     * 平均月支出
     */
    @Schema(description = "过去24个月每月里，你每月的平均开支为")
    private String monthlyExpense;

    /**
     * 累积流动资产
     */
    @Schema(description = "您现时的累积流动资产约有多少")
    private String liquidAssets;

    /**
     * 流动资产种类（A.现金 B.银行存款……）
     */
    @Schema(description = "流动资产种类（A.现金 B.银行存款 C.货币市场账户 D.交投活络的股票 E.债券及互惠基金 F.美国国库债券 G. 其他(請說明)）")
    private String liquidAssetType;

    /**
     * 保单持有人资产
     */
    @Schema(description = "保单持有人资产")
    private OwnerAssets ownerAssets;

    /**
     * 公司业务资料
     */
    @Schema(description = "公司业务资料")
    private CompanyBusinessData companyBusinessData;

    /**
     * 首期及续保保费的财富来源（A.储蓄 B.受雇收入 C.自雇收入 D.投资收入）
     */
    @Schema(description = "首期及续保保费的财富来源（A.储蓄 B.受雇收入 C.自雇收入 D.投资收入）")
    private String premiumFundingSource;


    /**
     * 封装类转对象
     *
     * @param fnaFormVO
     * @return
     */
    public static FnaForm voToObj(FnaFormVO fnaFormVO) {
        if (fnaFormVO == null) {
            return null;
        }
        FnaForm fnaForm = new FnaForm();
        BeanUtils.copyProperties(fnaFormVO, fnaForm);

        return fnaForm;
    }

    /**
     * 对象转封装类
     *
     * @param fnaForm
     * @return
     */
    public static FnaFormVO objToVo(FnaForm fnaForm) {
        if (fnaForm == null) {
            return null;
        }
        FnaFormVO fnaFormVO = new FnaFormVO();
        BeanUtils.copyProperties(fnaForm, fnaFormVO);

        return fnaFormVO;
    }
}
