package com.yd.csf.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 客户信息表
 * @TableName customer
 */
@TableName(value ="customer")
@Data
public class Customer implements Serializable {
    /**
     * id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 唯一业务ID
     */
    private String customerBizId;

    /**
     * 用户业务ID
     */
    private String userBizId;

    /**
     * 自定义代码
     */
    private String customCode;

    /**
     * 姓氏
     */
    private String lastName;

    /**
     * 名字
     */
    private String firstName;

    /**
     * 姓名
     */
    private String name;

    /**
     * 姓氏拼音
     */
    private String lastNamePinyin;

    /**
     * 名字-英文
     */
    private String firstNamePinyin;

    /**
     * 拼音全称
     */
    private String pinyin;

    /**
     * 称谓
     */
    private String title;

    /**
     * 性别
     */
    private Object gender;

    /**
     * 出生日期
     */
    private Date birthdate;

    /**
     * 异常信息
     */
    private String abnormal;

    /**
     * 年龄
     */
    private String age;

    /**
     * 地区代码
     */
    private String areaCode;

    /**
     * 电话号码
     */
    private String phone;

    /**
     * 电子邮箱
     */
    private String email;

    /**
     * 是否吸烟
     */
    private String smoke;

    /**
     * 吸烟数量
     */
    private String smokeQuantity;

    /**
     * 公司类型
     */
    private String companyType;

    /**
     * 来源
     */
    private String source;

    /**
     * 证件类型
     */
    private String idType;

    /**
     * 证件号码
     */
    private String idCard;

    /**
     * 护照号
     */
    private String passport;

    /**
     * EEP代码
     */
    private String eepCode;

    /**
     * 婚姻状况
     */
    private Object marriage;

    /**
     * 出生地
     */
    private String birthplace;

    /**
     * 教育程度
     */
    private Object education;

    /**
     * 签单用户扩展唯一业务ID
     */
    private String customerExpandBizId;

    /**
     * 国家
     */
    private String country;

    /**
     * 国家名称
     */
    private String countryName;

    /**
     * 通用备注
     */
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    private String creatorId;

    /**
     * 更新人ID
     */
    private String updaterId;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}