package com.yd.csf.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yd.csf.service.dto.AgentReferralRelationDto;
import com.yd.csf.service.model.AgentReferralRelation;
import com.yd.csf.service.dao.AgentReferralRelationMapper;
import com.yd.csf.service.model.AppointmentFile;
import com.yd.csf.service.service.IAgentReferralRelationService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * <p>
 * 推荐关系表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-10-15
 */
@Service
public class AgentReferralRelationServiceImpl extends ServiceImpl<AgentReferralRelationMapper, AgentReferralRelation> implements IAgentReferralRelationService {

    /**
     * 查询列表
     * @param dto
     * @return
     */
    @Override
    public List<AgentReferralRelation> queryList(AgentReferralRelationDto dto) {
        List<AgentReferralRelation> list = baseMapper.selectList(new LambdaQueryWrapper<AgentReferralRelation>()
                .eq(StringUtils.isNotBlank(dto.getTenantBizId()),AgentReferralRelation::getTenantBizId,dto.getTenantBizId())
                .eq(StringUtils.isNotBlank(dto.getProjectBizId()),AgentReferralRelation::getProjectBizId,dto.getProjectBizId())
                .in(!CollectionUtils.isEmpty(dto.getAgentIdList()),AgentReferralRelation::getAgentId,dto.getAgentIdList())
        );
        return list;
    }

    /**
     * 删除关系
     * @param agentId
     * @param referrerId
     * @return
     */
    @Override
    public Boolean del(String agentId, String referrerId) {
        return this.remove(new LambdaQueryWrapper<AgentReferralRelation>()
                .eq(AgentReferralRelation::getAgentId,agentId)
                .eq(AgentReferralRelation::getReferrerId,referrerId)
        );
    }

    /**
     * 删除关系
     * @param agentIdList
     * @param referrerId
     * @return
     */
    @Override
    public Boolean del(List<String> agentIdList, String referrerId) {
        return this.remove(new LambdaQueryWrapper<AgentReferralRelation>()
                .eq(AgentReferralRelation::getReferrerId,referrerId)
                .in(AgentReferralRelation::getAgentId,agentIdList)
        );
    }

}
