package com.yd.csf.service.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.csf.service.dto.*;
import com.yd.csf.service.model.Fortune;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yd.csf.service.vo.FortuneVO;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;

/**
* @author Zhang Jianan
* @description 针对表【fortune(保单发佣表)】的数据库操作Service
* @createDate 2025-09-22 13:22:09
*/
public interface FortuneService extends IService<Fortune> {

    Wrapper<Fortune> getQueryWrapper(FortuneQueryRequest fortuneQueryRequest);

    Page<FortuneVO> getFortuneVOPage(Page<Fortune> fortunePage);

    Boolean updateFortune(FortuneUpdateRequest fortuneUpdateRequest);

    void downloadFortune(FortuneDownloadRequest fortuneDownloadRequest, HttpServletResponse response) throws IOException;

    void downloadAccount(FortuneDownloadRequest fortuneDownloadRequest, HttpServletResponse response) throws UnsupportedEncodingException;

    Boolean updateFortuneStatus(FortuneStatusUpdateRequest fortuneStatusUpdateRequest);

    Fortune getByFortuneBizId(String fortuneBizId);

    Boolean addFortune(FortuneAddRequest fortuneAddRequest);

    Fortune queryOne(String fortuneBizId);

    FortuneStatisticsVO getFortuneStatistics(List<Long> fortuneIdList);
}
